#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.lib.python import templater
from crypta.profile.utils import luigi_utils
from crypta.profile.utils.segment_utils import (
    builders,
    processors,
)

AUTO_EVENTS = '//home/verticals/broker/prod/warehouse/auto/events/1d'

AUTO_QUERY_TEMPLATE = u"""
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$make_id_pack = ($id, $id_type) -> {
    RETURN AsStruct($id AS id, $id_type AS id_type);
};

INSERT INTO `{{output_table}}` WITH TRUNCATE
SELECT
    id_pack.id AS id,
    id_pack.id_type AS id_type,
    segment_name
FROM (
    SELECT
        CASE
            WHEN user_info.web_user_info.user_yandexuid IS NOT NULL THEN $make_id_pack(user_info.web_user_info.user_yandexuid, 'yandexuid')
            WHEN user_info.app_user_info.mobile_uuid IS NOT NULL THEN $make_id_pack(user_info.app_user_info.mobile_uuid, 'uuid')
            ELSE NULL -- это отфильтруется во внешнем запросе
        END AS id_pack,
        IF(offer.price < 2500000, 'auto_not_expensive', 'auto_expensive') AS segment_name
    FROM `{{auto_events}}`
    WHERE event_type IN ('CHAT_INIT', 'PHONE_CALL')
)
WHERE id_pack IS NOT NULL AND id_pack.id != "";
"""


class ProcessedAutoLogForAutoInteractions(processors.DayProcessor):
    def requires(self):
        return {
            'auto_events': luigi_utils.ExternalInput(os.path.join(AUTO_EVENTS, self.date))
        }

    def process_day(self, inputs, output_path):
        query = templater.render_template(
            AUTO_QUERY_TEMPLATE,
            vars={
                'auto_events': inputs['auto_events'].table,
                'output_table': output_path,
            },
            strict=True,
        )
        self.yql.query(
            query,
            transaction=self.transaction,
        )


class AutoInteractions(builders.RegularSegmentBuilder):
    number_of_days = 14

    name_segment_dict = {
        'auto_not_expensive': (557, 19790535),
        'auto_expensive': (557, 19790537),
    }

    def requires(self):
        return processors.LogProcessor(ProcessedAutoLogForAutoInteractions, self.date, self.number_of_days)

    def build_segment(self, inputs, output_path):

        self.yt.unique(
            inputs.table,
            output_path,
            unique_by=('id', 'id_type', 'segment_name'),
        )
