#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.runners.segments.lib.coded_segments.travellers import Travellers


avia_travellers_query_template = """
$visited_crypta_id = (
    SELECT
        matching.cryptaId AS crypta_id,
        Geo::RoundRegionById(travellers.region, "region").id as region
    FROM RANGE(`{traveller_storage}`) AS travellers
    INNER JOIN `{id_to_crypta_id_table}` AS matching
    USING(id, id_type)
);

$visited_but_not_live = (
    SELECT
        visited.crypta_id as id,
        'crypta_id' as id_type,
        CASE
            WHEN visited.region == 1 AND info.main_region != 1 THEN 'avia_moscow_visitors'
            WHEN visited.region == 10174 AND info.main_region != 10174 THEN 'avia_spb_visitors'
            WHEN Geo::IsRegionInRegion(CAST(visited.region AS Int32), 111) AND Geo::IsRegionInRegion(CAST(info.main_region AS Int32), 111) THEN 'avia_europe_visitors'
            WHEN Geo::IsRegionInRegion(CAST(visited.region AS Int32), 149) AND info.main_region_country != 149 THEN 'visited_by_kz_uz'
            WHEN Geo::IsRegionInRegion(CAST(visited.region AS Int32), 159) AND info.main_region_country != 159 THEN 'visited_by_kz_uz'
            WHEN Geo::IsRegionInRegion(CAST(visited.region AS Int32), 171) AND info.main_region_country != 171 THEN 'visited_by_kz_uz'
            ELSE NULL
        END as segment_name
    FROM $visited_crypta_id AS visited
    INNER JOIN `{crypta_id_regions}` AS info
    USING(crypta_id)
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT *
FROM $visited_but_not_live
WHERE segment_name IS NOT NULL
GROUP BY id, id_type, segment_name
"""


class AviaTravellers(RegularSegmentBuilder):
    indevice = True
    name_segment_dict = {
        'avia_moscow_visitors': (557, 5305681),
        'avia_spb_visitors': (557, 5305759),
        'avia_europe_visitors': (557, 5305588),
        'visited_by_kz_uz': (549, 1249),
    }

    def requires(self):
        return Travellers(self.date)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            avia_travellers_query_template.format(
                traveller_storage=os.path.join(config.DAY_PROCESSORS_OUTPUT_FOLDER, 'TravellersWeekly'),
                crypta_id_regions=config.GEO_CRYPTA_ID,
                id_to_crypta_id_table=config.VERTICES_NO_MULTI_PROFILE,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
