#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


segment_query = """
INSERT INTO `{output_table}` WITH TRUNCATE
SELECT id, id_type, 'bought_two_tickets' AS segment_name
FROM (
    SELECT *
    FROM (
        SELECT CAST(puid AS String) AS id, 'puid' AS id_type
        FROM `{input_table}`
        WHERE puid IS NOT NULL AND puid > 0
            AND event_type == 'movie'
            AND action_type == 'ticket.purchase.approved'
            AND created_dt >= '{date}'
            AND items_count == 2
    )
    UNION ALL
    SELECT *
    FROM (
        SELECT yuid AS id, 'yandexuid' AS id_type
        FROM `{input_table}`
        WHERE yuid IS NOT NULL
            AND CAST(yuid AS Uint64) IS NOT NULL
            AND yuid != '0'
            AND event_type == 'movie'
            AND action_type == 'ticket.purchase.approved'
            AND created_dt >= '{date}'
            AND items_count == 2
    )
)
GROUP BY id, id_type
"""


class BoughtTwoTickets(RegularSegmentBuilder):
    keyword = 557

    name_segment_dict = {
        'bought_two_tickets': 12908974,
    }

    def requires(self):
        return ExternalInput(config.AFISHA_TICKET_ORDER_LOG)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            segment_query.format(
                input_table=inputs.table,
                output_table=output_path,
                date=date_helpers.get_date_from_past(self.date, months=6),
            ),
            transaction=self.transaction,
        )
