#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor


query = """
PRAGMA yson.DisableStrict;

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT `UUID` AS id, 'uuid' AS id_type
FROM `{log_table}`
WHERE APIKey == 30488
    OR (APIKey == 4
        AND EventName == 'route.start-navigation'
        AND Yson::LookupString(Yson::ParseJson(EventValue), 'route_type') == 'car')
GROUP BY `UUID`
"""

merge_query = """
PRAGMA yt.InferSchema;

$car_owners = (
    SELECT id, id_type
    FROM `{dit_all_info_table}`
    WHERE car
);


INSERT INTO `{output_table}` WITH TRUNCATE
SELECT id, id_type, 'autodrivers' AS segment_name
FROM (
    SELECT id, id_type
    FROM `{map_and_navi_table}`
    UNION ALL
    SELECT id, id_type
    FROM $car_owners
)
GROUP BY id, id_type
"""


class MetrikaMobileLogForAutoDrivers(DayProcessor):
    def requires(self):
        return ExternalInput(
            os.path.join(
                config.APPMETRICA_YANDEX_EVENTS_LOG_FOLDER,
                self.date,
            ),
        )

    def process_day(self, inputs, output_path):
        self.yql.query(
            query_string=query.format(
                log_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class AutoDrivers(RegularSegmentBuilder):
    name_segment_dict = {
        'autodrivers': (547, 1051),
    }

    number_of_days = 14

    def requires(self):
        return {
            'MetrikaMobileLog': LogProcessor(
                MetrikaMobileLogForAutoDrivers,
                self.date,
                self.number_of_days,
            )
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            merge_query.format(
                output_table=output_path,
                dit_all_info_table=config.DIT_INFO_TABLE,
                map_and_navi_table=inputs['MetrikaMobileLog'].table,

            ),
            transaction=self.transaction,
        )
