import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInputDate
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.segment_utils.processors import (
    DayProcessor,
    LogProcessor,
)


external_events_processor_daily = """
INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT
    DeviceID AS id,
    'mm_device_id' AS id_type,
    'in_app_payers' AS segment_name,
FROM `{input_table}`
WHERE EventType == 21
    AND RevenuePrice > 0
    AND IsRevenueAutoCollected != -1
GROUP BY DeviceID;
"""


class ProcessedAppmetricaExternalDailyForPayers(DayProcessor):
    def requires(self):
        return ExternalInputDate(os.path.join(config.APPMETRICA_EXTERNAL_DAILY, self.date), self.date)

    def process_day(self, inputs, output_path):
        self.yql.query(
            external_events_processor_daily.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )


class InAppPayers(RegularSegmentBuilder):
    name_segment_dict = {
        'in_app_payers': (547, 2861),
    }

    number_of_days = 35

    def requires(self):
        return LogProcessor(
            ProcessedAppmetricaExternalDailyForPayers,
            self.date,
            self.number_of_days,
        )

    def build_segment(self, inputs, output_path):
        self.yt.unique(
            inputs.table,
            output_path,
            unique_by=('id', 'id_type', 'segment_name'),
        )
