#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


device_types_dict = {
    'tablet': {
        'all': 'tablets_owners',
        'android': 'android_tablets_owners',
        'ios': 'ios_tables_owners',
        'windows': 'windows_tablets_owners',
    },
    'phone': {
        'all': 'phones_owners',
        'android': 'android_phones_owners',
        'ios': 'ios_phones_owners',
        'windows': 'windows_phones_owners',
    },
}

vendors_dict = {
    'tablet': {
        'samsung': 'samsung_tablets_owners',
    },
    'phone': {
        'samsung': 'samsung_phones_owners',
    },
}


def device_mapper(row):
    if row['ua_profile']:
        ua_profile = row['ua_profile'].split('|', 4)
        if len(ua_profile) == 5:
            device_type_short, device_type, vendor, os_name, os_version = ua_profile

            if device_type in device_types_dict:
                yield {
                    'id': row['id'],
                    'id_type': row['id_type'],
                    'segment_name': device_types_dict[device_type]['all'],
                }
                if os_name in device_types_dict[device_type]:
                    yield {
                        'id': row['id'],
                        'id_type': row['id_type'],
                        'segment_name': device_types_dict[device_type][os_name],
                    }

            if vendors_dict.get(device_type, dict()).get(vendor):
                yield {
                    'id': row['id'],
                    'id_type': row['id_type'],
                    'segment_name': vendors_dict[device_type][vendor],
                }


class MobileDevicesOwners(RegularSegmentBuilder):
    name_segment_dict = {
        'android_tablets_owners': (547, 1055),
        'ios_tables_owners': (547, 1056),
        'windows_tablets_owners': (547, 1057),

        'android_phones_owners': (547, 1058),
        'ios_phones_owners': (547, 1059),
        'windows_phones_owners': (547, 1060),

        'tablets_owners': (216, 561),
        'phones_owners': (216, 562),
        'samsung_tablets_owners': (216, 615),
        'samsung_phones_owners': (216, 616),
    }

    def requires(self):
        return ExternalInput(
            config.YUID_WITH_ALL_INFO_TABLE,
            columns=('id', 'id_type', 'ua_profile'),
        )

    def build_segment(self, inputs, output_path):
        self.yt.run_map(
            device_mapper,
            inputs.table,
            output_path,
        )
