#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


users_with_smart_tv_query_template = """
$hhid_with_smart_tv = (
    SELECT
        hhid,
        AGGREGATE_LIST(yuid) AS household_yuids
    FROM `{hh_enrich_table}`
    GROUP BY hhid
    HAVING MAX(is_tv) == True
);

$cryptaid_with_smart_tv = (
    SELECT
        crypta_id,
        AGGREGATE_LIST(yuid) AS cryptaid_yuids
    FROM `{hh_enrich_table}`
    GROUP BY COALESCE(crypta_id, yuid) AS crypta_id
    HAVING MAX(is_tv) == True
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    id,
    'yandexuid' AS id_type,
    'hh_with_smart_tv' AS segment_name
FROM $hhid_with_smart_tv
FLATTEN BY household_yuids AS id
UNION ALL
SELECT
    id,
    'yandexuid' AS id_type,
    'cryptaid_with_smart_tv' AS segment_name
FROM $cryptaid_with_smart_tv
FLATTEN BY cryptaid_yuids AS id;
"""


class UsersWithSmartTv(RegularSegmentBuilder):
    name_segment_dict = {
        'hh_with_smart_tv': (547, 1061),
        'cryptaid_with_smart_tv': (547, 2677),
    }

    def requires(self):
        return ExternalInput(config.HOUSEHOLD_ENRICH_TABLE)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=users_with_smart_tv_query_template.format(
                hh_enrich_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
