#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.luigi_utils import ExternalInput


RUN = '//home/contest/production/run/run'
PARTICIPANTS = '//home/contest/production/participant/participant'
USERS = '//home/contest/production/users/users'

segment_query = """
PRAGMA yt.InferSchema = '100';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$python_compilers = (
    'python3_7_3',
    'python3_7',
    'python3_6',
    'ipython3',
    'ipython3v2',
    'mlblitz',
    'mlblitz_python26_numpy',
    'mlblitz_python27_numpy',
    'mlblitz_python36_numpy',
    'python2_6',
    'python3',
    'python3-ml',
    'python3_4',
    'python3_7_ml_modules',
    'python_docker_make'
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    u.login as id,
    'login' as id_type,
    'contest' as segment_name
FROM `{run}` as r
JOIN `{participants}` as p
ON r.participant_id == p.id
JOIN `{users}` as u
ON p.origin_user_id == u.id
WHERE
    r.compilerid IN $python_compilers AND
    u.usertype == 'PASSPORT' AND
    u.login IS NOT NULL
GROUP BY u.login;
"""


class ContestParticipants(RegularSegmentBuilder):

    name_segment_dict = {
        'contest': 17141284,
    }
    keyword = 557

    def requires(self):
        return {
            'Run': ExternalInput(RUN),
            'Participants': ExternalInput(PARTICIPANTS),
            'Users': ExternalInput(USERS),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            segment_query.format(
                run=inputs['Run'].table,
                participants=inputs['Participants'].table,
                users=inputs['Users'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
