#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.bed_model_training import (
    BedModelTrainHelper,
)
from crypta.profile.utils.config import config


class BedModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'bed_0_10': 2267,
        'bed_10_20': 2268,
        'bed_80_90': 2271,
        'bed_90_100': 2270,
    }
    audience_segments = {18188920, 18188917, 18188923, 18188929}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Кровати и матрасы',
            objective='Долю оплаченных и доставленных заказов',
            positive_conversions='Оплатили и получили заказ',
            negative_conversions='Отменили заказ',
        )

    @cached_property
    def train_helper(self):
        return BedModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.BED_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.BED_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('bed_90_100', (0.0, 0.1)),
            ('bed_80_90', (0.1, 0.2)),
            ('bed_10_20', (0.8, 0.9)),
            ('bed_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'bed_90_100',
            1: 'bed_80_90',
            2: 'bed_10_20',
            3: 'bed_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @cached_property
    def industry_name(self):
        return 'furniture'
