#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


select_prism_segments_query = """
INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT
    id,
    id_type,
    CASE
        WHEN score >= 0.9 THEN 'bnpl_0_10'
        WHEN score >= 0.8 THEN 'bnpl_10_20'
        WHEN score >= 0.7 THEN 'bnpl_20_30'
        WHEN score >= 0.6 THEN 'bnpl_30_40'
        WHEN score >= 0.5 THEN 'bnpl_40_50'
        WHEN score >= 0.4 THEN 'bnpl_50_60'
        WHEN score >= 0.3 THEN 'bnpl_60_70'
        WHEN score >= 0.2 THEN 'bnpl_70_80'
        WHEN score >= 0.1 THEN 'bnpl_80_90'
        ELSE 'bnpl_90_100'
    END AS segment_name,
    score_raw AS probability
FROM `{input_table}`;
"""


class BnplScoring(RegularSegmentBuilder):
    juggler_host = config.CRYPTA_ML_JUGGLER_HOST
    keyword = 546

    name_segment_dict = {
        'bnpl_0_10': 2515,
        'bnpl_10_20': 2514,
        'bnpl_20_30': 2513,
        'bnpl_30_40': 2512,
        'bnpl_40_50': 2511,
        'bnpl_50_60': 2510,
        'bnpl_60_70': 2509,
        'bnpl_70_80': 2508,
        'bnpl_80_90': 2507,
        'bnpl_90_100': 2516,
    }

    def requires(self):
        return ExternalInput(os.path.join(config.BNPL_SCORING_BY_ID, self.date))

    def build_segment(self, inputs, output_path):
        self.yql.query(
            select_prism_segments_query.format(
                input_table=inputs.table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
