#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.cash_settlement_services_model_training import (
    CashSettlementServicesModelTrainHelper,
)
from crypta.profile.utils.config import config


class CashSettlementServicesModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'cash_settlement_services_0_10': 2283,
        'cash_settlement_services_10_20': 2278,
        'cash_settlement_services_20_30': 2272,
        'cash_settlement_services_30_40': 2282,
        'cash_settlement_services_40_50': 2273,
        'cash_settlement_services_50_60': 2279,
        'cash_settlement_services_60_70': 2274,
        'cash_settlement_services_70_80': 2285,
        'cash_settlement_services_80_90': 2281,
        'cash_settlement_services_90_100': 2275,
    }
    audience_segments = {
        18434890, 18434869, 19462996, 19463002, 19463014, 19463017, 19463020, 19463023, 18434875, 18434878,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Расчетно-кассовое обслуживание',
            objective='Долю открытых счетов',
            positive_conversions='Оставили заявку и потом открыли счет',
            negative_conversions='Оставили заявку, но счет НЕ открыли',
        )

    @cached_property
    def train_helper(self):
        return CashSettlementServicesModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.CASH_SETTLEMENT_SERVICES_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.CASH_SETTLEMENT_SERVICES_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('cash_settlement_services_90_100', (0.0, 0.1)),
            ('cash_settlement_services_80_90', (0.1, 0.2)),
            ('cash_settlement_services_70_80', (0.2, 0.3)),
            ('cash_settlement_services_60_70', (0.3, 0.4)),
            ('cash_settlement_services_50_60', (0.4, 0.5)),
            ('cash_settlement_services_40_50', (0.5, 0.6)),
            ('cash_settlement_services_30_40', (0.6, 0.7)),
            ('cash_settlement_services_20_30', (0.7, 0.8)),
            ('cash_settlement_services_10_20', (0.8, 0.9)),
            ('cash_settlement_services_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'cash_settlement_services_90_100',
            1: 'cash_settlement_services_80_90',
            2: 'cash_settlement_services_70_80',
            3: 'cash_settlement_services_60_70',
            4: 'cash_settlement_services_50_60',
            5: 'cash_settlement_services_40_50',
            6: 'cash_settlement_services_30_40',
            7: 'cash_settlement_services_20_30',
            8: 'cash_settlement_services_10_20',
            9: 'cash_settlement_services_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'rko'
