#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.cosmetics_buyers_model_training import (
    CosmeticsModelTrainHelper,
)
from crypta.profile.utils.config import config


class CosmeticsModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'cosmetics_0_10': 2286,
        'cosmetics_10_20': 2287,
        'cosmetics_80_90': 2289,
        'cosmetics_90_100': 2288,
    }
    audience_segments = {18176395, 18176407, 18176404, 18176398}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Косметика',
            objective='Долю оплаченных и доставленных заказов',
            positive_conversions='Оплатили и получили заказ',
            negative_conversions='Отменили заказ',
        )

    @cached_property
    def train_helper(self):
        return CosmeticsModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.COSMETICS_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.COSMETICS_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('cosmetics_90_100', (0.0, 0.1)),
            ('cosmetics_80_90', (0.1, 0.2)),
            ('cosmetics_10_20', (0.8, 0.9)),
            ('cosmetics_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'cosmetics_90_100',
            1: 'cosmetics_80_90',
            2: 'cosmetics_10_20',
            3: 'cosmetics_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'cosmetics'
