#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.credit_card_model_training import (
    CreditCardModelTrainHelper,
)
from crypta.profile.utils.config import config


class CreditCardModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'credit_card_0_10': 2920,
        'credit_card_10_20': 2921,
        'credit_card_80_90': 2922,
        'credit_card_90_100': 2923,
    }
    audience_segments = {21933812, 21933813, 21933872, 21933838}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Кредитные карты (одобрение)',
            objective='Долю одобренных кредитных карт',
            positive_conversions='Пользователю выдали кредитную карту',
            negative_conversions='Пользователю отказали в выдаче кредитной карты',
        )

    @cached_property
    def train_helper(self):
        return CreditCardModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.CREDIT_CARD_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.CREDIT_CARD_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('credit_card_90_100', (0.0, 0.1)),
            ('credit_card_80_90', (0.1, 0.2)),
            ('credit_card_10_20', (0.8, 0.9)),
            ('credit_card_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'credit_card_90_100',
            1: 'credit_card_80_90',
            2: 'credit_card_10_20',
            3: 'credit_card_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'credit_card'
