#!/usr/bin/env python
# -*- coding: utf-8 -*-

import luigi

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.bed_model_application import BedModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.bnpl import BnplScoring
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.cash_settlement_services_model_application import CashSettlementServicesModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.credit_card_model_application import CreditCardModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.custom_income_model_application import CustomIncomeModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.debit_cards_activation_model_application import DebitCardsActivationModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.ebook_model_application import EbookModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.electronic_model_application import ElectronicModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.english_online_education_model_application import EnglishOnlineEducationModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.food_delivery_model_application import FoodDeliveryModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.furniture_buyers_model_application import FurnitureModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.game_login_model_application import GameLoginModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_car_credit_approval_model_application import GenericCarCreditApprovalModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_credit_approval_model_application import GenericCreditApprovalModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_microfinance_approval_model_application import GenericMicrofinanceApprovalModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_scoring_model_application import GenericScoringModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.healthy_food_model_application import HealthyFoodModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.home_depot_model_application import HomeDepotModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.hotel_model_application import HotelModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.investment_model_application import InvestmentModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.legal_entities_model_application import LegalEntitiesModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.legal_office_visits_model_application import LegalOfficeVisitsModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.market_model_application import MarketModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.market_rfm_model_application import MarketRfmModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.marriage_model_application import MarriageModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.online_cinema_model_application import OnlineCinemaModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.online_sales_register_model_application import OnlineSalesRegisterModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.online_shopping_model_application import OnlineShoppingModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.realty_visit_model_application import RealtyVisitModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.tv_viewers_model_application import TvViewersModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.windows_installation_model_application import WindowsInstallationModelApplication


class CustomClassification(luigi.WrapperTask):
    date = luigi.Parameter()

    def requires(self):
        return {
            'bed': BedModelApplication(self.date),
            'bnpl': BnplScoring(self.date),
            'cash_settlement_services': CashSettlementServicesModelApplication(self.date),
            'credit_card': CreditCardModelApplication(self.date),
            'custom_income': CustomIncomeModelApplication(self.date),
            'debit_cards_activation': DebitCardsActivationModelApplication(self.date),
            'ebook': EbookModelApplication(self.date),
            'electronic': ElectronicModelApplication(self.date),
            'english_online_education': EnglishOnlineEducationModelApplication(self.date),
            'food_delivery': FoodDeliveryModelApplication(self.date),
            'furniture': FurnitureModelApplication(self.date),
            'game_login': GameLoginModelApplication(self.date),
            'generic_credit_approval': GenericCreditApprovalModelApplication(self.date),
            'generic_car_credit_approval': GenericCarCreditApprovalModelApplication(self.date),
            'generic_microfinance_approval': GenericMicrofinanceApprovalModelApplication(self.date),
            'generic_scoring': GenericScoringModelApplication(self.date),
            'healthy_food': HealthyFoodModelApplication(self.date),
            'home_depot': HomeDepotModelApplication(self.date),
            'hotel': HotelModelApplication(self.date),
            'investment': InvestmentModelApplication(self.date),
            'legal_entities': LegalEntitiesModelApplication(self.date),
            'legal_office_visits': LegalOfficeVisitsModelApplication(self.date),
            'market': MarketModelApplication(self.date),
            'market_rfm': MarketRfmModelApplication(self.date),
            'marriage': MarriageModelApplication(self.date),
            'online_cinema': OnlineCinemaModelApplication(self.date),
            'online_sales_register': OnlineSalesRegisterModelApplication(self.date),
            'online_shopping': OnlineShoppingModelApplication(self.date),
            'realty_visit': RealtyVisitModelApplication(self.date),
            'tv_viewers': TvViewersModelApplication(self.date),
            'windows_installation': WindowsInstallationModelApplication(self.date),
        }
