#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.custom_income_model_training import CustomIncomeModelTrainHelper
from crypta.profile.utils.config import config


class CustomIncomeModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'custom_income_0_1': 2638,
        'custom_income_1_5': 2637,
        'custom_income_5_10': 2639,
        'custom_income_10_20': 2640,
        'custom_income_20_30': 2641,
        'custom_income_30_40': 2642,
        'custom_income_40_50': 2643,
        'custom_income_50_60': 2644,
        'custom_income_60_70': 2645,
        'custom_income_70_80': 2646,
        'custom_income_80_90': 2647,
        'custom_income_90_100': 2648,
    }

    audience_segments = {
        20560169,
        20560177,
        20560182,
        20560190,
        20560201,
        20560216,
        20560228,
        20560247,
        20560260,
        20560277,
        20560303,
        20560315,
    }

    @cached_property
    def train_helper(self):
        return CustomIncomeModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.CUSTOM_INCOME_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.CUSTOM_INCOME_TRAIN_SAMPLE_BY_YUID,
        )

    @property
    def percentiles(self):
        return OrderedDict([
            ('custom_income_90_100', (0.0, 0.1)),
            ('custom_income_80_90', (0.1, 0.2)),
            ('custom_income_70_80', (0.2, 0.3)),
            ('custom_income_60_70', (0.3, 0.4)),
            ('custom_income_50_60', (0.4, 0.5)),
            ('custom_income_40_50', (0.5, 0.6)),
            ('custom_income_30_40', (0.6, 0.7)),
            ('custom_income_20_30', (0.7, 0.8)),
            ('custom_income_10_20', (0.8, 0.9)),
            ('custom_income_5_10', (0.9, 0.95)),
            ('custom_income_1_5', (0.95, 0.99)),
            ('custom_income_0_1', (0.99, 1.0)),
        ])

    @property
    def slice_to_segment_name_dict(self):
        return {
            0: 'custom_income_90_100',
            1: 'custom_income_80_90',
            2: 'custom_income_70_80',
            3: 'custom_income_60_70',
            4: 'custom_income_50_60',
            5: 'custom_income_40_50',
            6: 'custom_income_30_40',
            7: 'custom_income_20_30',
            8: 'custom_income_10_20',
            9: 'custom_income_5_10',
            10: 'custom_income_1_5',
            11: 'custom_income_0_1',
        }

    @property
    def positive_name(self):
        return None

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()
