#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.dating_model_training import (
    DatingModelTrainHelper,
)
from crypta.profile.utils.config import config


class DatingModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'dating_0_10': 2871,
        'dating_10_20': 2872,
        'dating_80_90': 2873,
        'dating_90_100': 2874,
    }
    audience_segments = {21352998, 21352999, 21353000, 21353001}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Сайты знакомств',
            objective='Долю пользователей, которые платят за премиум подписку',
            positive_conversions='Пользователь зарегистрировался и оплатил премиум подписку',
            negative_conversions='Пользователь зарегистрировался, но не оплатил премиум подписку',
        )

    @cached_property
    def train_helper(self):
        return DatingModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.DATING_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.DATING_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('dating_90_100', (0.0, 0.1)),
            ('dating_80_90', (0.1, 0.2)),
            ('dating_10_20', (0.8, 0.9)),
            ('dating_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'dating_90_100',
            1: 'dating_80_90',
            2: 'dating_10_20',
            3: 'dating_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'dating'
