#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.debit_cards_activation_model_training import (
    DebitCardsActivationModelTrainHelper,
)
from crypta.profile.utils.config import config


class DebitCardsActivationModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'debit_cards_activation_0_10': 2763,
        'debit_cards_activation_10_20': 2760,
        'debit_cards_activation_20_30': 2940,
        'debit_cards_activation_70_80': 2941,
        'debit_cards_activation_80_90': 2761,
        'debit_cards_activation_90_100': 2762,
    }
    audience_segments = {
        20962270, 20962235, 20962252, 20962258, 22268700, 22268703,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Активация дебетовых карт',
            objective='Долю пользователей, забравших дебетовую карту и совершивших первую транзакцию',
            positive_conversions='Пользователь забрал карту и совершил транзакцию',
            negative_conversions='Пользователь не забрал карту',
        )

    @cached_property
    def train_helper(self):
        return DebitCardsActivationModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.DEBIT_CARDS_ACTIVATION_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.DEBIT_CARDS_ACTIVATION_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('debit_cards_activation_90_100', (0.0, 0.1)),
            ('debit_cards_activation_80_90', (0.1, 0.2)),
            ('debit_cards_activation_70_80', (0.2, 0.3)),
            ('debit_cards_activation_20_30', (0.7, 0.8)),
            ('debit_cards_activation_10_20', (0.8, 0.9)),
            ('debit_cards_activation_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'debit_cards_activation_90_100',
            1: 'debit_cards_activation_80_90',
            2: 'debit_cards_activation_70_80',
            3: 'debit_cards_activation_20_30',
            4: 'debit_cards_activation_10_20',
            5: 'debit_cards_activation_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'debit_cards'
