#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.ebook_model_training import (
    EbookModelTrainHelper,
)
from crypta.profile.utils.config import config


class EbookModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'ebook_0_10': 2292,
        'ebook_10_20': 2291,
        'ebook_80_90': 2293,
        'ebook_90_100': 2290,
    }
    audience_segments = {18052084, 18052087, 18052093, 18052099}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Электронные книги',
            objective='Долю активных покупателей',
            positive_conversions='С суммой покупок более 3000 руб за год',
            negative_conversions='Зарегистрировались и ничего не купили',
        )

    @cached_property
    def train_helper(self):
        return EbookModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.EBOOK_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.EBOOK_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('ebook_90_100', (0.0, 0.1)),
            ('ebook_80_90', (0.1, 0.2)),
            ('ebook_10_20', (0.8, 0.9)),
            ('ebook_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'ebook_90_100',
            1: 'ebook_80_90',
            2: 'ebook_10_20',
            3: 'ebook_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'ebooks'
