#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.electronic_model_training import (
    ElectronicModelTrainHelper,
)
from crypta.profile.utils.config import config


class ElectronicModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'electronic_0_10': 2295,
        'electronic_10_20': 2297,
        'electronic_80_90': 2296,
        'electronic_90_100': 2294,
    }
    audience_segments = {18082981, 18082984, 18082987, 18082990}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Электроника и цифровая техника',
            objective='Долю выкупленных заказов',
            positive_conversions='Заказ выкуплен',
            negative_conversions='Заказ не выкуплен',
        )

    @cached_property
    def train_helper(self):
        return ElectronicModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.ELECTRONIC_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.ELECTRONIC_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('electronic_90_100', (0.0, 0.1)),
            ('electronic_80_90', (0.1, 0.2)),
            ('electronic_10_20', (0.8, 0.9)),
            ('electronic_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'electronic_90_100',
            1: 'electronic_80_90',
            2: 'electronic_10_20',
            3: 'electronic_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'electronic'
