#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.english_online_education_model_training import (
    EnglishOnlineEducationModelTrainHelper,
)
from crypta.profile.utils.config import config


class EnglishOnlineEducationModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'english_online_education_0_10': 2303,
        'english_online_education_10_20': 2300,
        'english_online_education_20_30': 2302,
        'english_online_education_70_80': 2301,
        'english_online_education_80_90': 2299,
        'english_online_education_90_100': 2298,
    }
    audience_segments = {16934341, 16934344, 17339917, 17340838, 16934347, 16934350}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Онлайн образование (английский язык)',
            objective='Долю платных подписок',
            positive_conversions='Регистрация + оплата подписки',
            negative_conversions='Регистрация без оплаты подписки',
        )

    @cached_property
    def train_helper(self):
        return EnglishOnlineEducationModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.ENGLISH_ONLINE_EDUCATION_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.ENGLISH_ONLINE_EDUCATION_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('english_online_education_90_100', (0.0, 0.1)),
            ('english_online_education_80_90', (0.1, 0.2)),
            ('english_online_education_70_80', (0.2, 0.3)),
            ('english_online_education_20_30', (0.7, 0.8)),
            ('english_online_education_10_20', (0.8, 0.9)),
            ('english_online_education_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'english_online_education_90_100',
            1: 'english_online_education_80_90',
            2: 'english_online_education_70_80',
            3: 'english_online_education_20_30',
            4: 'english_online_education_10_20',
            5: 'english_online_education_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'education'
