#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.food_delivery_model_training import (
    FoodDeliveryModelTrainHelper,
)
from crypta.profile.utils.config import config


class FoodDeliveryModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'food_delivery_0_10': 2305,
        'food_delivery_10_20': 2310,
        'food_delivery_80_90': 2306,
        'food_delivery_90_100': 2307,
    }
    audience_segments = {18318112, 18318103, 18318106, 18318109}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Доставка еды',
            objective='Долю оплачиваемых заказов',
            positive_conversions='Заказали и оплатили',
            negative_conversions='Заказали и не оплатили',
        )

    @cached_property
    def train_helper(self):
        return FoodDeliveryModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.FOOD_DELIVERY_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.FOOD_DELIVERY_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('food_delivery_90_100', (0.0, 0.1)),
            ('food_delivery_80_90', (0.1, 0.2)),
            ('food_delivery_10_20', (0.8, 0.9)),
            ('food_delivery_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'food_delivery_90_100',
            1: 'food_delivery_80_90',
            2: 'food_delivery_10_20',
            3: 'food_delivery_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'food'
