#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.furniture_buyers_model_training import (
    FurnitureModelTrainHelper,
)
from crypta.profile.utils.config import config


class FurnitureModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'furniture_0_10': 2315,
        'furniture_10_20': 2312,
        'furniture_80_90': 2313,
        'furniture_90_100': 2314,
    }
    audience_segments = {17311399, 17311366, 17311384, 17311393}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Мебель',
            objective='Долю заключенных договоров',
            positive_conversions='Заключили договор с пользователем',
            negative_conversions='Не заключили договор с пользователем',
        )

    @cached_property
    def train_helper(self):
        return FurnitureModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.FURNITURE_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.FURNITURE_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('furniture_90_100', (0.0, 0.1)),
            ('furniture_80_90', (0.1, 0.2)),
            ('furniture_10_20', (0.8, 0.9)),
            ('furniture_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'furniture_90_100',
            1: 'furniture_80_90',
            2: 'furniture_10_20',
            3: 'furniture_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'furniture'
