#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.game_login_model_training import GameLoginModelTrainHelper
from crypta.profile.utils.config import config


class GameLoginModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'game_login_0_10': 2318,
        'game_login_10_20': 2316,
        'game_login_20_30': 2317,
        'game_login_30_40': 2323,
        'game_login_40_50': 2325,
        'game_login_50_60': 2322,
        'game_login_60_70': 2319,
        'game_login_70_80': 2324,
        'game_login_80_90': 2321,
        'game_login_90_100': 2320,
    }
    audience_segments = {
        16917826, 16917829, 16917835, 16917838, 16917841, 16917844, 16917847, 16917850, 16917853, 16917859,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Игровая индустрия',
            objective='Долю залогиненных пользователей',
            positive_conversions='Залогинились',
            negative_conversions='Играли, но не залогинились',
        )

    @cached_property
    def train_helper(self):
        return GameLoginModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.GAME_LOGIN_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.GAME_LOGIN_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('game_login_90_100', (0.0, 0.1)),
            ('game_login_80_90', (0.1, 0.2)),
            ('game_login_70_80', (0.2, 0.3)),
            ('game_login_60_70', (0.3, 0.4)),
            ('game_login_50_60', (0.4, 0.5)),
            ('game_login_40_50', (0.5, 0.6)),
            ('game_login_30_40', (0.6, 0.7)),
            ('game_login_20_30', (0.7, 0.8)),
            ('game_login_10_20', (0.8, 0.9)),
            ('game_login_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'game_login_90_100',
            1: 'game_login_80_90',
            2: 'game_login_70_80',
            3: 'game_login_60_70',
            4: 'game_login_50_60',
            5: 'game_login_40_50',
            6: 'game_login_30_40',
            7: 'game_login_20_30',
            8: 'game_login_10_20',
            9: 'game_login_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'games'
