#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_car_credit_approval_model_training import (
    GenericCarCreditApprovalModelTrainHelper,
)
from crypta.profile.utils.config import config


class GenericCarCreditApprovalModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'generic_car_credit_approval_0_10': 2624,
        'generic_car_credit_approval_10_20': 2621,
        'generic_car_credit_approval_20_30': 2626,
        'generic_car_credit_approval_30_40': 2625,
        'generic_car_credit_approval_40_50': 2627,
        'generic_car_credit_approval_50_60': 2628,
        'generic_car_credit_approval_60_70': 2629,
        'generic_car_credit_approval_70_80': 2630,
        'generic_car_credit_approval_80_90': 2622,
        'generic_car_credit_approval_90_100': 2623,
    }
    audience_segments = {
        20382363, 20382360, 20384236, 20384237, 20384238, 20384239, 20384240, 20384241, 20382361, 20382362,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Автокредиты (одобрение)',
            objective='Долю одобренных кредитов',
            positive_conversions='Пользователю выдали кредит',
            negative_conversions='Пользователю отказали в выдаче кредита',
        )

    @cached_property
    def train_helper(self):
        return GenericCarCreditApprovalModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.GENERIC_CAR_CREDIT_APPROVAL_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.GENERIC_CAR_CREDIT_APPROVAL_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('generic_car_credit_approval_90_100', (0.0, 0.1)),
            ('generic_car_credit_approval_80_90', (0.1, 0.2)),
            ('generic_car_credit_approval_70_80', (0.2, 0.3)),
            ('generic_car_credit_approval_60_70', (0.3, 0.4)),
            ('generic_car_credit_approval_50_60', (0.4, 0.5)),
            ('generic_car_credit_approval_40_50', (0.5, 0.6)),
            ('generic_car_credit_approval_30_40', (0.6, 0.7)),
            ('generic_car_credit_approval_20_30', (0.7, 0.8)),
            ('generic_car_credit_approval_10_20', (0.8, 0.9)),
            ('generic_car_credit_approval_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'generic_car_credit_approval_90_100',
            1: 'generic_car_credit_approval_80_90',
            2: 'generic_car_credit_approval_70_80',
            3: 'generic_car_credit_approval_60_70',
            4: 'generic_car_credit_approval_50_60',
            5: 'generic_car_credit_approval_40_50',
            6: 'generic_car_credit_approval_30_40',
            7: 'generic_car_credit_approval_20_30',
            8: 'generic_car_credit_approval_10_20',
            9: 'generic_car_credit_approval_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'car_credit'
