#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_insurance_model_training import (
    GenericInsuranceModelTrainHelper,
)
from crypta.profile.utils.config import config


class GenericInsuranceModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'generic_insurance_0_10': 2341,
        'generic_insurance_10_20': 2343,
        'generic_insurance_20_30': 2337,
        'generic_insurance_30_40': 2338,
        'generic_insurance_40_50': 2340,
        'generic_insurance_50_60': 2345,
        'generic_insurance_60_70': 2342,
        'generic_insurance_70_80': 2336,
        'generic_insurance_80_90': 2344,
        'generic_insurance_90_100': 2339,
    }
    audience_segments = {
        16369615, 16369630, 16369627, 16369621, 16369612, 16369618, 16369633, 16369606, 16369609, 16369624,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Страхование',
            objective='Долю купленных полисов',
            positive_conversions='Оставили заявку на расчет стоимости - купили полис',
            negative_conversions='Оставили заявку на расчет стоимости - не купили полис',
        )

    @cached_property
    def train_helper(self):
        return GenericInsuranceModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.GENERIC_INSURANCE_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.GENERIC_INSURANCE_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('generic_insurance_90_100', (0.0, 0.1)),
            ('generic_insurance_80_90', (0.1, 0.2)),
            ('generic_insurance_70_80', (0.2, 0.3)),
            ('generic_insurance_60_70', (0.3, 0.4)),
            ('generic_insurance_50_60', (0.4, 0.5)),
            ('generic_insurance_40_50', (0.5, 0.6)),
            ('generic_insurance_30_40', (0.6, 0.7)),
            ('generic_insurance_20_30', (0.7, 0.8)),
            ('generic_insurance_10_20', (0.8, 0.9)),
            ('generic_insurance_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'generic_insurance_90_100',
            1: 'generic_insurance_80_90',
            2: 'generic_insurance_70_80',
            3: 'generic_insurance_60_70',
            4: 'generic_insurance_50_60',
            5: 'generic_insurance_40_50',
            6: 'generic_insurance_30_40',
            7: 'generic_insurance_20_30',
            8: 'generic_insurance_10_20',
            9: 'generic_insurance_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'insurance'
