#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_microfinance_approval_model_training import (
    GenericMicrofinanceApprovalModelTrainHelper,
)
from crypta.profile.utils.config import config


class GenericMicrofinanceApprovalModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'generic_microfinance_approval_0_10': 2355,
        'generic_microfinance_approval_10_20': 2354,
        'generic_microfinance_approval_20_30': 2353,
        'generic_microfinance_approval_30_40': 2350,
        'generic_microfinance_approval_40_50': 2349,
        'generic_microfinance_approval_50_60': 2348,
        'generic_microfinance_approval_60_70': 2351,
        'generic_microfinance_approval_70_80': 2352,
        'generic_microfinance_approval_80_90': 2347,
        'generic_microfinance_approval_90_100': 2346,
    }
    audience_segments = {
        16917802, 16917793, 16917814, 16917805, 16917811, 16917778, 16917784, 16917781, 16917808, 16917775
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Микрофинансы (одобрение)',
            objective='Долю одобренных кредитов',
            positive_conversions='Пользователю выдали кредит',
            negative_conversions='Пользователю отказали в выдаче кредита',
        )

    @cached_property
    def train_helper(self):
        return GenericMicrofinanceApprovalModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.GENERIC_MICROFINANCE_APPROVAL_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.GENERIC_MICROFINANCE_APPROVAL_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('generic_microfinance_approval_90_100', (0.0, 0.1)),
            ('generic_microfinance_approval_80_90', (0.1, 0.2)),
            ('generic_microfinance_approval_70_80', (0.2, 0.3)),
            ('generic_microfinance_approval_60_70', (0.3, 0.4)),
            ('generic_microfinance_approval_50_60', (0.4, 0.5)),
            ('generic_microfinance_approval_40_50', (0.5, 0.6)),
            ('generic_microfinance_approval_30_40', (0.6, 0.7)),
            ('generic_microfinance_approval_20_30', (0.7, 0.8)),
            ('generic_microfinance_approval_10_20', (0.8, 0.9)),
            ('generic_microfinance_approval_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'generic_microfinance_approval_90_100',
            1: 'generic_microfinance_approval_80_90',
            2: 'generic_microfinance_approval_70_80',
            3: 'generic_microfinance_approval_60_70',
            4: 'generic_microfinance_approval_50_60',
            5: 'generic_microfinance_approval_40_50',
            6: 'generic_microfinance_approval_30_40',
            7: 'generic_microfinance_approval_20_30',
            8: 'generic_microfinance_approval_10_20',
            9: 'generic_microfinance_approval_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'mircrofinance'
