#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.generic_scoring_model_training import (
    GenericScoringModelTrainHelper,
)
from crypta.profile.utils.config import config


class GenericScoringModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'generic_scoring_0_10': 2362,
        'generic_scoring_10_20': 2360,
        'generic_scoring_20_30': 2356,
        'generic_scoring_30_40': 2361,
        'generic_scoring_40_50': 2363,
        'generic_scoring_50_60': 2357,
        'generic_scoring_60_70': 2364,
        'generic_scoring_70_80': 2358,
        'generic_scoring_80_90': 2359,
        'generic_scoring_90_100': 2365,
    }
    audience_segments = {
        16232113, 16232134, 16232137, 16232116, 16232122, 16232107, 16232131, 16232143, 16232110, 16232128,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Банковские кредиты (погашение)',
            objective='Долю возвращенных кредитов',
            positive_conversions='Пользователь вернул или исправно возвращает кредит',
            negative_conversions='Пользователь допустил просрочку 60 дней на горизонте 6 месяцев',
        )

    @cached_property
    def train_helper(self):
        return GenericScoringModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.GENERIC_SCORING_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.GENERIC_SCORING_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('generic_scoring_90_100', (0.0, 0.1)),
            ('generic_scoring_80_90', (0.1, 0.2)),
            ('generic_scoring_70_80', (0.2, 0.3)),
            ('generic_scoring_60_70', (0.3, 0.4)),
            ('generic_scoring_50_60', (0.4, 0.5)),
            ('generic_scoring_40_50', (0.5, 0.6)),
            ('generic_scoring_30_40', (0.6, 0.7)),
            ('generic_scoring_20_30', (0.7, 0.8)),
            ('generic_scoring_10_20', (0.8, 0.9)),
            ('generic_scoring_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'generic_scoring_90_100',
            1: 'generic_scoring_80_90',
            2: 'generic_scoring_70_80',
            3: 'generic_scoring_60_70',
            4: 'generic_scoring_50_60',
            5: 'generic_scoring_40_50',
            6: 'generic_scoring_30_40',
            7: 'generic_scoring_20_30',
            8: 'generic_scoring_10_20',
            9: 'generic_scoring_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'banking'
