#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.healthy_food_model_training import (
    HealthyFoodModelTrainHelper,
)
from crypta.profile.utils.config import config


class HealthyFoodModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'healthy_food_0_10': 2304,
        'healthy_food_10_20': 2309,
        'healthy_food_80_90': 2311,
        'healthy_food_90_100': 2308,
    }
    audience_segments = {18421774, 18421765, 18421768, 18421771}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Здоровое питание',
            objective='Долю оплачиваемых заказов',
            positive_conversions='Заказали и оплатили',
            negative_conversions='Заказали и не оплатили',
        )

    @cached_property
    def train_helper(self):
        return HealthyFoodModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.HEALTHY_FOOD_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.HEALTHY_FOOD_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('healthy_food_90_100', (0.0, 0.1)),
            ('healthy_food_80_90', (0.1, 0.2)),
            ('healthy_food_10_20', (0.8, 0.9)),
            ('healthy_food_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'healthy_food_90_100',
            1: 'healthy_food_80_90',
            2: 'healthy_food_10_20',
            3: 'healthy_food_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'food'
