#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.home_depot_model_training import (
    HomeDepotModelTrainHelper,
)
from crypta.profile.utils.config import config


class HomeDepotModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'home_depot_0_10': 2425,
        'home_depot_10_20': 2422,
        'home_depot_80_90': 2423,
        'home_depot_90_100': 2424,
    }
    audience_segments = {19917315, 19917312, 19917313, 19917314}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Строительные магазины',
            objective='Долю пользователей, выкупающих заказы',
            positive_conversions='Выкупили заказ',
            negative_conversions='Не выкупили заказ',
        )

    @cached_property
    def train_helper(self):
        return HomeDepotModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.HOME_DEPOT_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.HOME_DEPOT_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('home_depot_90_100', (0.0, 0.1)),
            ('home_depot_80_90', (0.1, 0.2)),
            ('home_depot_10_20', (0.8, 0.9)),
            ('home_depot_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'home_depot_90_100',
            1: 'home_depot_80_90',
            2: 'home_depot_10_20',
            3: 'home_depot_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'home_depot'
