#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.hotel_model_training import (
    HotelModelTrainHelper,
)
from crypta.profile.utils.config import config


class HotelModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'hotel_0_10': 2369,
        'hotel_10_20': 2367,
        'hotel_80_90': 2368,
        'hotel_90_100': 2366,
    }
    audience_segments = {17020759, 17020780, 17020783, 17020756}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Путешествия (отели)',
            objective='Долю оплаченных номеров',
            positive_conversions='Бронирование + оплата проживания',
            negative_conversions='Бронирование без оплаты',
        )

    @cached_property
    def train_helper(self):
        return HotelModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.HOTEL_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.HOTEL_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('hotel_90_100', (0.0, 0.1)),
            ('hotel_80_90', (0.1, 0.2)),
            ('hotel_10_20', (0.8, 0.9)),
            ('hotel_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'hotel_90_100',
            1: 'hotel_80_90',
            2: 'hotel_10_20',
            3: 'hotel_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'tourism'
