#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.investment_model_training import (
    InvestmentModelTrainHelper,
)
from crypta.profile.utils.config import config


class InvestmentModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'investment_0_10': 22166258,
        'investment_10_20': 22166255,
        'investment_80_90': 22166256,
        'investment_90_100': 22166257,
    }
    audience_segments = {24092860, 24092837, 24092857, 24092859}

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Инвестиции',
            objective='Долю пользователей, которые покупают активы',
            positive_conversions='Пользователь открыл счет и купил активы',
            negative_conversions='Пользователь открыл счет, но не купил активы',
        )

    @cached_property
    def train_helper(self):
        return InvestmentModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.INVESTMENT_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.INVESTMENT_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('investment_90_100', (0.0, 0.1)),
            ('investment_80_90', (0.1, 0.2)),
            ('investment_10_20', (0.8, 0.9)),
            ('investment_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'investment_90_100',
            1: 'investment_80_90',
            2: 'investment_10_20',
            3: 'investment_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'investment'
