#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.legal_entities_model_training import (
    LegalEntitiesModelTrainHelper,
)
from crypta.profile.utils.config import config


class LegalEntitiesModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'legal_entities_0_10': 2378,
        'legal_entities_10_20': 2373,
        'legal_entities_20_30': 2374,
        'legal_entities_30_40': 2379,
        'legal_entities_40_50': 2370,
        'legal_entities_50_60': 2376,
        'legal_entities_60_70': 2372,
        'legal_entities_70_80': 2377,
        'legal_entities_80_90': 2371,
        'legal_entities_90_100': 2375,
    }
    audience_segments = {
        17044543, 17044540, 17044546, 17044549, 17044525, 17044528, 17044534, 17044552, 17044531, 17044537,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Представители юридических лиц',
            objective='Долю юридических лиц',
            positive_conversions='Представители юридических лиц или ИП',
            negative_conversions='Физические лица',
        )

    @cached_property
    def train_helper(self):
        return LegalEntitiesModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.LEGAL_ENTITIES_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.LEGAL_ENTITIES_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('legal_entities_90_100', (0.0, 0.1)),
            ('legal_entities_80_90', (0.1, 0.2)),
            ('legal_entities_70_80', (0.2, 0.3)),
            ('legal_entities_60_70', (0.3, 0.4)),
            ('legal_entities_50_60', (0.4, 0.5)),
            ('legal_entities_40_50', (0.5, 0.6)),
            ('legal_entities_30_40', (0.6, 0.7)),
            ('legal_entities_20_30', (0.7, 0.8)),
            ('legal_entities_10_20', (0.8, 0.9)),
            ('legal_entities_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'legal_entities_90_100',
            1: 'legal_entities_80_90',
            2: 'legal_entities_70_80',
            3: 'legal_entities_60_70',
            4: 'legal_entities_50_60',
            5: 'legal_entities_40_50',
            6: 'legal_entities_30_40',
            7: 'legal_entities_20_30',
            8: 'legal_entities_10_20',
            9: 'legal_entities_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'legal_entities'
