#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.legal_office_visits_model_training import (
    LegalOfficeVisitsModelTrainHelper,
)
from crypta.profile.utils.config import config


class LegalOfficeVisitsModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'arranged_visit_0_10': 2383,
        'arranged_visit_10_20': 2380,
        'arranged_visit_80_90': 2382,
        'arranged_visit_90_100': 2381,
    }

    audience_segments = {
        19537222, 19537220, 19537219, 19537221,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Юридические услуги',
            objective='Долю заключенных договоров',
            positive_conversions='Отправили заявку, записались на консультацию в офис, заключили договор',
            negative_conversions='Не брали трубку после отправки заявки, либо оставляли ненастоящие номера в форме',
        )

    @cached_property
    def train_helper(self):
        return LegalOfficeVisitsModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.LEGAL_OFFICE_VISITS_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.LEGAL_OFFICE_VISITS_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('arranged_visit_90_100', (0.0, 0.1)),
            ('arranged_visit_80_90', (0.1, 0.2)),
            ('arranged_visit_10_20', (0.8, 0.9)),
            ('arranged_visit_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'arranged_visit_90_100',
            1: 'arranged_visit_80_90',
            2: 'arranged_visit_10_20',
            3: 'arranged_visit_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'legal_services'
