#!/usr/bin/env python
# -*- coding: utf-8 -*-

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.market_model_training import MarketModelTrainHelper
from crypta.profile.utils.config import config


class MarketModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'mammies': 1299,
        'regional_youth': 1300,
        'men_artisans': 1301,
        'advanced_youth': 1302,
        'active_women': 1303,
        'successful_men': 1304,
        'age_conservatives': 1305,
    }

    @cached_property
    def train_helper(self):
        return MarketModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.MARKET_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.MARKET_TRAIN_SAMPLE_BY_YUID,
        )

    @property
    def percentiles(self):
        return None

    @property
    def slice_to_segment_name_dict(self):
        return None

    @property
    def positive_name(self):
        return None

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.ordered_thresholds.keys()
