#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.market_rfm_model_training import (
    MarketRfmModelTrainHelper,
)
from crypta.profile.utils.config import config


class MarketRfmModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'market_rfm_0_10': 2391,
        'market_rfm_10_20': 2388,
        'market_rfm_80_90': 2390,
        'market_rfm_90_100': 2389,
    }
    audience_segments = {
        18208216, 18208222, 18208219, 18208228,
    }

    @cached_property
    def train_helper(self):
        return MarketRfmModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.MARKET_RFM_STORAGE,
            train_sample_path=config.MARKET_RFM_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('market_rfm_90_100', (0.0, 0.1)),
            ('market_rfm_80_90', (0.1, 0.2)),
            ('market_rfm_10_20', (0.8, 0.9)),
            ('market_rfm_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'market_rfm_90_100',
            1: 'market_rfm_80_90',
            2: 'market_rfm_10_20',
            3: 'market_rfm_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'market'
