#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.marriage_model_training import MarriageModelTrainHelper
from crypta.profile.utils.config import config


class MarriageModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'not_married': 2466,
        'married': 2465,
    }

    @cached_property
    def train_helper(self):
        return MarriageModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.MARRIAGE_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.MARRIAGE_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('not_married', (0.0, 0.3)),
            ('married', (0.7, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'not_married',
            1: 'married',
        }

    @cached_property
    def positive_name(self):
        return 'married'

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.ordered_thresholds.keys()

    @property
    def industry_name(self):
        return 'marriage'
