#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.medical_clinic_model_training import (
    MedicalClinicModelTrainHelper,
)
from crypta.profile.utils.config import config


class MedicalClinicModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'medical_clinics_0_20': 2392,
        'medical_clinics_80_100': 2393,

        'medical_clinics_0_10': 2979,
        'medical_clinics_10_20': 2988,
        'medical_clinics_20_30': 2987,
        'medical_clinics_30_40': 2986,
        'medical_clinics_40_50': 2985,
        'medical_clinics_50_60': 2984,
        'medical_clinics_60_70': 2983,
        'medical_clinics_70_80': 2982,
        'medical_clinics_80_90': 2981,
        'medical_clinics_90_100': 2980,
    }
    audience_segments = {
        16316131, 16316164,
        22579400, 22579410, 22579409, 22579408, 22579407, 22579406, 22579404, 22579403, 22579402, 22579401,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Медицинские клиники',
            objective='Доходимость до клиники',
            positive_conversions='Пользователь записался и пришел на прием',
            negative_conversions='Пользователь записался, но не пришел на прием',
        )

    @cached_property
    def train_helper(self):
        return MedicalClinicModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.MEDICAL_CLINIC_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.MEDICAL_CLINIC_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('medical_clinics_90_100', (0.0, 0.1)),
            ('medical_clinics_80_90', (0.1, 0.2)),
            ('medical_clinics_70_80', (0.2, 0.3)),
            ('medical_clinics_60_70', (0.3, 0.4)),
            ('medical_clinics_50_60', (0.4, 0.5)),
            ('medical_clinics_40_50', (0.5, 0.6)),
            ('medical_clinics_30_40', (0.6, 0.7)),
            ('medical_clinics_20_30', (0.7, 0.8)),
            ('medical_clinics_10_20', (0.8, 0.9)),
            ('medical_clinics_0_10', (0.9, 1.0)),

            ('medical_clinics_80_100', (0.0, 0.2)),
            ('medical_clinics_0_20', (0.8, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'medical_clinics_90_100',
            1: 'medical_clinics_80_90',
            2: 'medical_clinics_70_80',
            3: 'medical_clinics_60_70',
            4: 'medical_clinics_50_60',
            5: 'medical_clinics_40_50',
            6: 'medical_clinics_30_40',
            7: 'medical_clinics_20_30',
            8: 'medical_clinics_10_20',
            9: 'medical_clinics_0_10',

            10: 'medical_clinics_80_100',
            11: 'medical_clinics_0_20',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'medicine'
