#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.mortgage_approval_model_training import (
    MortgageApprovalModelTrainHelper,
)
from crypta.profile.utils.config import config


class MortgageApprovalModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'mortgage_approval_0_10': 2740,
        'mortgage_approval_10_20': 	2739,
        'mortgage_approval_80_90': 	2742,
        'mortgage_approval_90_100': 2741,
    }
    audience_segments = {
        20760175, 20760171, 20760173, 20760174,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Ипотека (одобрение)',
            objective='Долю одобренных ипотек',
            positive_conversions='Пользователю одобрили ипотеку',
            negative_conversions='Пользователю отказали в выдаче ипотеки',
        )

    @cached_property
    def train_helper(self):
        return MortgageApprovalModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.MORTGAGE_APPROVAL_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.MORTGAGE_APPROVAL_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('mortgage_approval_90_100', (0.0, 0.1)),
            ('mortgage_approval_80_90', (0.1, 0.2)),
            ('mortgage_approval_10_20', (0.8, 0.9)),
            ('mortgage_approval_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'mortgage_approval_90_100',
            1: 'mortgage_approval_80_90',
            2: 'mortgage_approval_10_20',
            3: 'mortgage_approval_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'mortgage_approval'
