#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.online_cinema_model_training import (
    OnlineCinemaModelTrainHelper,
)
from crypta.profile.utils.config import config


class OnlineCinemaModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'online_cinema_0_10': 2397,
        'online_cinema_10_20': 2396,
        'online_cinema_80_90': 2394,
        'online_cinema_90_100': 2395,
    }
    audience_segments = {
        18437716, 18437722, 18437713, 18437719,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Онлайн-кинотеатры',
            objective='Долю купленных подписок',
            positive_conversions='Зарегистрировались и оформили триал/купили подписку',
            negative_conversions='Зарегистрировались и 3 месяца+ не оформляли триал/купили подписку',
        )

    @cached_property
    def train_helper(self):
        return OnlineCinemaModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.ONLINE_CINEMA_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.ONLINE_CINEMA_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('online_cinema_90_100', (0.0, 0.1)),
            ('online_cinema_80_90', (0.1, 0.2)),
            ('online_cinema_10_20', (0.8, 0.9)),
            ('online_cinema_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'online_cinema_90_100',
            1: 'online_cinema_80_90',
            2: 'online_cinema_10_20',
            3: 'online_cinema_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'cinema'
