#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.online_payment_model_training import (
    OnlinePaymentModelTrainHelper,
)
from crypta.profile.utils.config import config


class OnlinePaymentModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'online_payment_0_10': 2399,
        'online_payment_10_20': 2401,
        'online_payment_80_90': 2398,
        'online_payment_90_100': 2400,
    }
    audience_segments = {
        19585382, 19585381, 19585380, 19585384,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Финансы',
            objective='Долю совершенных переводов',
            positive_conversions='Пользователи, перешедшие на сайт и сделавшие перевод',
            negative_conversions='Пользователи, перешедшие на сайт и не сделавшие перевод',
        )

    @cached_property
    def train_helper(self):
        return OnlinePaymentModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.ONLINE_PAYMENT_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.ONLINE_PAYMENT_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('online_payment_90_100', (0.0, 0.1)),
            ('online_payment_80_90', (0.1, 0.2)),
            ('online_payment_10_20', (0.8, 0.9)),
            ('online_payment_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'online_payment_90_100',
            1: 'online_payment_80_90',
            2: 'online_payment_10_20',
            3: 'online_payment_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'finance'
