#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.online_sales_register_model_training import (
    OnlineSalesRegisterModelTrainHelper,
)
from crypta.profile.utils.config import config


class OnlineSalesRegisterModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'online_sales_register_0_10': 2277,
        'online_sales_register_10_20': 2276,
        'online_sales_register_80_90': 2284,
        'online_sales_register_90_100': 2280,
    }
    audience_segments = {
        18318154, 18318142, 18318145, 18318151,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Онлайн-кассы',
            objective='Долю оплачиваемых счетов',
            positive_conversions='Оплатили счет',
            negative_conversions='Не оплатили счет',
        )

    @cached_property
    def train_helper(self):
        return OnlineSalesRegisterModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.ONLINE_SALES_REGISTER_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.ONLINE_SALES_REGISTER_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('online_sales_register_90_100', (0.0, 0.1)),
            ('online_sales_register_80_90', (0.1, 0.2)),
            ('online_sales_register_10_20', (0.8, 0.9)),
            ('online_sales_register_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'online_sales_register_90_100',
            1: 'online_sales_register_80_90',
            2: 'online_sales_register_10_20',
            3: 'online_sales_register_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'rko'
