#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.online_shopping_model_training import (
    OnlineShoppingModelTrainHelper,
)
from crypta.profile.utils.config import config


class OnlineShoppingModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'online_shopping_0_10': 2404,
        'online_shopping_10_20': 2403,
        'online_shopping_80_90': 2402,
        'online_shopping_90_100': 2405,
    }
    audience_segments = {
        17965255, 17965270, 17965240, 17965198,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Интернет-магазины (данная индустрия преимущественно про одежду)',
            objective='Долю выкупленных заказов',
            positive_conversions='Сделали заказ и выкупили его',
            negative_conversions='Сделали заказ, но не выкупили его',
        )

    @cached_property
    def train_helper(self):
        return OnlineShoppingModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.ONLINE_SHOPPING_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.ONLINE_SHOPPING_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('online_shopping_90_100', (0.0, 0.1)),
            ('online_shopping_80_90', (0.1, 0.2)),
            ('online_shopping_10_20', (0.8, 0.9)),
            ('online_shopping_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'online_shopping_90_100',
            1: 'online_shopping_80_90',
            2: 'online_shopping_10_20',
            3: 'online_shopping_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'shopping'
