#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.pharmacy_model_training import (
    PharmacyModelTrainHelper,
)
from crypta.profile.utils.config import config


class PharmacyModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'pharmacy_0_10': 2260,
        'pharmacy_10_20': 2257,
        'pharmacy_80_90': 2258,
        'pharmacy_90_100': 2259,
    }
    audience_segments = {
        18437767, 18437770, 18437773, 18437764,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Фармацевтика',
            objective='Долю постоянных клиентов',
            positive_conversions='Постоянные клиенты',
            negative_conversions='Сделали одну покупку и больше не появлялись',
        )

    @cached_property
    def train_helper(self):
        return PharmacyModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.PHARMACY_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.PHARMACY_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('pharmacy_90_100', (0.0, 0.1)),
            ('pharmacy_80_90', (0.1, 0.2)),
            ('pharmacy_10_20', (0.8, 0.9)),
            ('pharmacy_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'pharmacy_90_100',
            1: 'pharmacy_80_90',
            2: 'pharmacy_10_20',
            3: 'pharmacy_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'pharmacy'
