#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.realty_visit_model_training import (
    RealtyVisitModelTrainHelper,
)
from crypta.profile.utils.config import config


class RealtyVisitModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'realty_visit_0_10': 2408,
        'realty_visit_10_20': 2406,
        'realty_visit_80_90': 2409,
        'realty_visit_90_100': 2407,
    }
    audience_segments = {
        18327109, 18327103, 18327100, 18327106,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Недвижимость, визиты',
            objective='Долю пользователей, пришедших на просмотр',
            positive_conversions='Контактировали, договорились о визите',
            negative_conversions='Контактировали, не договорились о визите',
        )

    @cached_property
    def train_helper(self):
        return RealtyVisitModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.REALTY_VISIT_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.REALTY_VISIT_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('realty_visit_90_100', (0.0, 0.1)),
            ('realty_visit_80_90', (0.1, 0.2)),
            ('realty_visit_10_20', (0.8, 0.9)),
            ('realty_visit_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'realty_visit_90_100',
            1: 'realty_visit_80_90',
            2: 'realty_visit_10_20',
            3: 'realty_visit_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'realty'
