#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.tv_viewers_model_training import TvViewersModelTrainHelper
from crypta.profile.utils.config import config


class TvViewersModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'light_tv_viewers': 2467,
        'heavy_tv_viewers': 2468,
    }

    @cached_property
    def train_helper(self):
        return TvViewersModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.TV_VIEWERS_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.TV_VIEWERS_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('light_tv_viewers', (0.0, 0.15)),
            ('heavy_tv_viewers', (0.85, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'light_tv_viewers',
            1: 'heavy_tv_viewers',
        }

    @cached_property
    def positive_name(self):
        return 'heavy_tv_viewers'

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.ordered_thresholds.keys()

    @property
    def industry_name(self):
        return 'tv_viewers'
