#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_classification.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_classification.windows_installation_model_training import (
    WindowsInstallationModelTrainHelper,
)
from crypta.profile.utils.config import config


class WindowsInstallationModelApplication(AbstractModelApplication):
    keyword = 546

    name_segment_dict = {
        'windows_installation_0_10': 2485,
        'windows_installation_10_20': 2482,
        'windows_installation_80_90': 2483,
        'windows_installation_90_100': 2484,
    }
    audience_segments = {
        19995865, 19995866, 19995867, 19995868,
    }

    @property
    def model_description(self):
        return self.ModelDescription(
            industry='Окна',
            objective='Долю конверсии в покупку при обращении',
            positive_conversions='Обратились, но не сделали покупку',
            negative_conversions='Обратились и сделали покупку',
        )

    @cached_property
    def train_helper(self):
        return WindowsInstallationModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.WINDOWS_INSTALLATION_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.WINDOWS_INSTALLATION_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('windows_installation_90_100', (0.0, 0.1)),
            ('windows_installation_80_90', (0.1, 0.2)),
            ('windows_installation_10_20', (0.8, 0.9)),
            ('windows_installation_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'windows_installation_90_100',
            1: 'windows_installation_80_90',
            2: 'windows_installation_10_20',
            3: 'windows_installation_0_10',
        }

    @cached_property
    def probability_classes(self):
        return self.train_helper.model_params.segment_id_to_name.values()

    @property
    def industry_name(self):
        return 'windows'
