#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import OrderedDict

from cached_property import cached_property

from crypta.profile.runners.segments.lib.coded_segments.custom_regression.abstract_model_application import AbstractModelApplication
from crypta.profile.runners.segments.lib.coded_segments.custom_regression.heavy_suite_model_training import HeavySuiteModelTrainHelper
from crypta.profile.utils.config import config


class HeavySuiteModelApplication(AbstractModelApplication):
    keyword = 557

    name_segment_dict = {
        'heavy_suite_0_10': 17449555,
        'heavy_suite_10_20': 17449558,
        'heavy_suite_80_90': 17449561,
        'heavy_suite_90_100': 17449564,
    }

    @cached_property
    def train_helper(self):
        return HeavySuiteModelTrainHelper(
            yt=self.yt,
            logger=self.logger,
            date=self.date,
            storage_sample_path=config.HEAVY_SUITE_TRAIN_SAMPLE_BY_PUID,
            train_sample_path=config.HEAVY_SUITE_TRAIN_SAMPLE_BY_YUID,
        )

    @cached_property
    def percentiles(self):
        return OrderedDict([
            ('heavy_suite_90_100', (0.0, 0.1)),
            ('heavy_suite_80_90', (0.1, 0.2)),
            ('heavy_suite_10_20', (0.8, 0.9)),
            ('heavy_suite_0_10', (0.9, 1.0)),
        ])

    @cached_property
    def slice_to_segment_name_dict(self):
        return {
            0: 'heavy_suite_90_100',
            1: 'heavy_suite_80_90',
            2: 'heavy_suite_10_20',
            3: 'heavy_suite_0_10',
        }
