#!/usr/bin/env python
# -*- coding: utf-8 -*-

from cached_property import cached_property

from crypta.lib.python.custom_ml.regression import (
    CustomRegressionModelTrainHelper,
    CustomRegressionParams,
)
from crypta.lib.python.custom_ml.regression.model_training import make_common_regression_train_sample_query
from crypta.profile.runners.segments.lib.coded_segments.ml_tools.utils import (
    get_model_tag,
    resources,
)


class HeavySuiteModelTrainHelper(CustomRegressionModelTrainHelper):
    def __init__(self, yt, logger, date, storage_sample_path, train_sample_path):
        super(HeavySuiteModelTrainHelper, self).__init__(yt=yt, logger=logger, date=date)
        self.storage_sample_path = storage_sample_path
        self.train_sample_path = train_sample_path
        self.model_name = 'heavy_suite'

    @cached_property
    def model_params(self):

        return CustomRegressionParams(
            train_sample_path=self.train_sample_path,
            resource_type=resources[self.model_name],
            model_tag=get_model_tag(self.model_name),
            metrics_group_name=self.get_metrics_group_name(self.model_name),
            model_description_in_sandbox='Model for heavy suite segments regression',
            make_train_sample_query=make_common_regression_train_sample_query.format(
                input_table=self.storage_sample_path,
                output_table=self.train_sample_path,
                additional_conditions='',
            ),
        )
