#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


segment_query = """
$with_gaid = (
    SELECT id2 AS id
    FROM `{gaid_table}`
);

$with_oaid = (
    SELECT id2 AS id
    FROM `{oaid_table}`
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT DISTINCT t1.id AS id, 'mm_device_id' AS id_type, 'without_google_services' AS segment_name
FROM $with_oaid AS t1
LEFT ONLY JOIN $with_gaid AS t2
USING (id)
"""


class WithoutGoogleServices(RegularSegmentBuilder):
    name_segment_dict = {
        'without_google_services': (557, 18315067),
    }

    def requires(self):
        return {
            'oaid_mm_device_id': ExternalInput(os.path.join(config.CRYPTA_GRAPH_SOUP_DIR, 'oaid_mm_device_id_app-metrica_mm')),
            'gaid_mm_device_id': ExternalInput(os.path.join(config.CRYPTA_GRAPH_SOUP_DIR, 'gaid_mm_device_id_app-metrica_mm')),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=segment_query.format(
                gaid_table=inputs['gaid_mm_device_id'].table,
                oaid_table=inputs['oaid_mm_device_id'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
