#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.processors import DayProcessor, LogProcessor

disk_users_query_template = """
INSERT INTO `{output_table}`
SELECT puid as id, 'puid' as id_type, 'active_disk_users' as segment_name FROM `{disk_logs}`
WITH SCHEMA Struct<puid:String>;
"""


def map_disk_users(row):
    yield row


def reduce_disk_users(key, rows):
    data = dict(key)
    yield data


class ProcessedDiskLogForDiskUsers(DayProcessor):
    def requires(self):
        return ExternalInput(
            os.path.join(config.DISK_ACTIVITY_LOG, self.date)
        )

    def process_day(self, inputs, output_path):
        self.yt.run_map_reduce(
            map_disk_users,
            reduce_disk_users,
            inputs.table,
            output_path,
            reduce_by='puid',
        )


class DiskUsers(RegularSegmentBuilder):
    keyword = 549
    number_of_days = 182

    name_segment_dict = {
        'active_disk_users': 1310
    }

    def requires(self):
        return {
            'ProcessedDiskLog': LogProcessor(
                ProcessedDiskLogForDiskUsers,
                date_helpers.get_yesterday(self.date),
                self.number_of_days,
            ),
        }

    def build_segment(self, inputs, output_path):

        self.yql.query(
            disk_users_query_template.format(
                disk_logs=inputs['ProcessedDiskLog'].table,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
